/*
 * Decompiled with CFR 0.152.
 */
package net.ssterling.bukkitversion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class BukkitVersion
implements Comparable<BukkitVersion> {
    protected boolean beta;
    protected Integer major;
    protected Integer minor;
    protected Integer patch;
    protected Integer prerelease;
    protected Integer release_candidate;
    protected Integer revision_major;
    protected Integer revision_minor;
    private static final int RC_OFFSET = 10000;
    private static final int PRERC_NULL_VALUE = 20000;
    private static final Pattern PATTERN = Pattern.compile("^(?<beta>b)?(?<major>\\d+)(?:\\.(?<minor>\\d+)(?:(?:\\.(?<patch>[0-9]+))?(?:(?:-pre(?<pre>\\d))|(?:-rc(?<rc>\\d+))?)?(?:-R(?<revisionmajor>\\d)(?:.(?<revisionminor>\\d))?)?(?<snapshot>-SNAPSHOT)?)?)?$");

    public BukkitVersion() {
        try {
            this.fromString(Bukkit.getBukkitVersion(), true);
        }
        catch (NoSuchMethodError ex) {
            try {
                Pattern pattern = Pattern.compile("\\(MC: 1\\.(?<minor>\\d)(?:\\.(?<patch>\\d))?\\)");
                String version = Bukkit.getVersion();
                Matcher matcher = PATTERN.matcher(version);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("unhandled beta version");
                }
                this.beta = true;
                this.major = 1;
                this.minor = Integer.parseInt(matcher.group("minor"));
                if (matcher.group("patch") != null) {
                    this.patch = Integer.parseInt(matcher.group("patch"));
                }
            }
            catch (NoSuchMethodError exx) {
                throw new NoSuchMethodError("cannot find Bukkit API");
            }
        }
    }

    public BukkitVersion(String version) {
        this.fromString(version, true);
    }

    public BukkitVersion(String version, boolean strict) {
        this.fromString(version, strict);
    }

    public BukkitVersion(Integer major, Integer minor, Integer patch, Integer prerelease, Integer release_candidate, Integer revision_major, Integer revision_minor) {
        if (major == null || minor == null) {
            throw new IllegalArgumentException("major and minor version numbers are required parameters");
        }
        if (prerelease != null && release_candidate != null) {
            throw new IllegalArgumentException("pre-releases and release candidates are mutually exclusive");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.release_candidate = release_candidate;
        this.revision_major = revision_major;
        this.revision_minor = revision_minor;
    }

    private void fromString(String version, boolean strict) {
        if (version == null) {
            throw new NullPointerException("null version string");
        }
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid vanilla version");
        }
        if (matcher.group("snapshot") == null && strict) {
            throw new IllegalArgumentException("invalid Bukkit API version");
        }
        this.major = Integer.parseInt(matcher.group("major"));
        if (matcher.group("minor") != null) {
            this.minor = Integer.parseInt(matcher.group("minor"));
        }
        if (matcher.group("patch") != null) {
            this.patch = Integer.parseInt(matcher.group("patch"));
        }
        if (matcher.group("pre") != null) {
            this.prerelease = Integer.parseInt(matcher.group("pre"));
        }
        if (matcher.group("rc") != null) {
            this.release_candidate = Integer.parseInt(matcher.group("rc"));
        }
        if (matcher.group("revisionmajor") != null) {
            this.revision_major = Integer.parseInt(matcher.group("revisionmajor"));
        }
        if (matcher.group("revisionminor") != null) {
            this.revision_minor = Integer.parseInt(matcher.group("revisionminor"));
        }
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public Integer getPrerelease() {
        return this.prerelease;
    }

    public Integer getReleaseCandidate() {
        return this.release_candidate;
    }

    protected Integer getPrereleaseOrReleaseCandidate() {
        if (this.prerelease != null) {
            return this.prerelease;
        }
        if (this.release_candidate != null) {
            return this.release_candidate + 10000;
        }
        return 20000;
    }

    public Integer getRevisionMajor() {
        return this.revision_major;
    }

    public Integer getRevisionMinor() {
        return this.revision_minor;
    }

    public String toVanillaString() {
        return this.major + "." + this.minor + (this.patch == null ? "" : "." + this.patch) + (this.prerelease == null ? "" : "-pre" + this.prerelease) + (this.release_candidate == null ? "" : "-rc" + this.release_candidate);
    }

    public String toString() {
        return this.toVanillaString() + (this.revision_major == null ? "" : "-R" + this.revision_major) + (this.revision_minor == null ? "" : "." + this.revision_minor) + "-SNAPSHOT";
    }

    @Override
    public int compareTo(BukkitVersion compare) {
        return this.compareTo(compare, Component.REVISION_MINOR);
    }

    public int compareTo(BukkitVersion compare, Component granularity) {
        int offset = 0;
        int compare_offset = 0;
        if (compare.toString().matches("^1.19.1(?:-.+)?$")) {
            if (this.prerelease > 1) {
                offset = 10001;
            } else if (this.release_candidate != null) {
                offset = 10100;
            }
        }
        if (compare.toString().matches("^1.19.1(?:-.+)?$")) {
            if (compare.getPrerelease() > 1) {
                compare_offset = 10001;
            } else if (compare.getReleaseCandidate() != null) {
                compare_offset = 10100;
            }
        }
        if (this.major > compare.getMajor()) {
            return 1;
        }
        if (this.major < compare.getMajor()) {
            return -1;
        }
        if (granularity.compareTo(Component.MINOR) > 1) {
            return 0;
        }
        if (this.minor > compare.getMinor()) {
            return 1;
        }
        if (this.minor < compare.getMinor()) {
            return -1;
        }
        if (granularity.compareTo(Component.PATCH) > 1) {
            return 0;
        }
        if (this.patch > compare.getPatch()) {
            return 1;
        }
        if (this.patch < compare.getPatch()) {
            return -1;
        }
        if (granularity.compareTo(Component.PRE_RC) > 1) {
            return 0;
        }
        if (this.getPrereleaseOrReleaseCandidate() + offset > compare.getPrereleaseOrReleaseCandidate() + compare_offset) {
            return 1;
        }
        if (this.getPrereleaseOrReleaseCandidate() + offset < compare.getPrereleaseOrReleaseCandidate() + compare_offset) {
            return -1;
        }
        if (granularity.compareTo(Component.REVISION_MAJOR) > 1) {
            return 0;
        }
        if (this.revision_major > compare.getRevisionMajor()) {
            return 1;
        }
        if (this.revision_major < compare.getRevisionMajor()) {
            return -1;
        }
        if (granularity.compareTo(Component.REVISION_MINOR) > 1) {
            return 0;
        }
        if (this.revision_minor > compare.getRevisionMinor()) {
            return 1;
        }
        if (this.revision_minor < compare.getRevisionMinor()) {
            return -1;
        }
        return 0;
    }

    public static enum Component {
        MAJOR,
        MINOR,
        PATCH,
        PRE_RC,
        REVISION_MAJOR,
        REVISION_MINOR;

    }
}

